/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

/**
 * Bildet Wertpaare aus Feldname und Feldtyp ab, um 
 * entsprechende Datentypenconvertierungen zu ermglichen.
 * @author Thomas Ekert
 *
 */
public class Column {
	private String name=null;
	private int type = -1;
	
	public static final int TYPE_UNDEFINED= -1;
	public static final int TYPE_STRING = 0;
	public static final int TYPE_DATE = 1;
	public static final int TYPE_LONG = 2;
	public static final int TYPE_DATELIST = 3;
	public static final int TYPE_LONGLIST = 4;
	
	public Column (String fieldName, int type) {
		if (type < TYPE_STRING || type > TYPE_LONGLIST) {
			type = TYPE_UNDEFINED;
		}
		this.name=fieldName; this.type=type;
	}
	
	public String getName () { return name;}
	public int getType () { return type;}
}
